<?php

use Illuminate\Support\Facades\Route;

Route::namespace('User\Auth')->name('user.')->middleware('guest')->group(function () {
    Route::controller('LoginController')->group(function () {
        Route::get('/login', 'showLoginForm')->name('login');
        Route::post('/login', 'login');
        Route::get('logout', 'logout')->middleware('auth')->withoutMiddleware('guest')->name('logout');
    });

    Route::controller('RegisterController')->group(function () {
        Route::get('register', 'showRegistrationForm')->name('register');
        Route::post('register', 'register');
        Route::post('check-user', 'checkUser')->name('checkUser')->withoutMiddleware('guest');
    });

    Route::controller('ForgotPasswordController')->prefix('password')->name('password.')->group(function () {
        Route::get('reset', 'showLinkRequestForm')->name('request');
        Route::post('email', 'sendResetCodeEmail')->name('email');
        Route::get('code-verify', 'codeVerify')->name('code.verify');
        Route::post('verify-code', 'verifyCode')->name('verify.code');
    });

    Route::controller('ResetPasswordController')->group(function () {
        Route::post('password/reset', 'reset')->name('password.update');
        Route::get('password/reset/{token}', 'showResetForm')->name('password.reset');
    });

    Route::controller('SocialiteController')->group(function () {
        Route::get('social-login/{provider}', 'socialLogin')->name('social.login');
        Route::get('social-login/callback/{provider}', 'callback')->name('social.login.callback');
    });
});

Route::middleware('auth')->name('user.')->group(function () {

    Route::get('user-data', 'User\UserController@userData')->name('data');
    Route::post('user-data-submit', 'User\UserController@userDataSubmit')->name('data.submit');

    //authorization
    Route::middleware('registration.complete')->namespace('User')->controller('AuthorizationController')->group(function () {
        Route::get('authorization', 'authorizeForm')->name('authorization');
        Route::get('resend-verify/{type}', 'sendVerifyCode')->name('send.verify.code');
        Route::post('verify-email', 'emailVerification')->name('verify.email');
        Route::post('verify-mobile', 'mobileVerification')->name('verify.mobile');
        Route::post('verify-g2fa', 'g2faVerification')->name('2fa.verify');
    });
    Route::middleware(['check.status', 'registration.complete'])->group(function () {

        Route::namespace('User')->group(function () {

            Route::controller('UserController')->group(function () {
                Route::get('dashboard', 'home')->name('home');
                Route::get('download-attachments/{file_hash}', 'downloadAttachment')->name('download.attachment');

                //2FA
                Route::get('twofactor', 'show2faForm')->name('twofactor');
                Route::post('twofactor/enable', 'create2fa')->name('twofactor.enable');
                Route::post('twofactor/disable', 'disable2fa')->name('twofactor.disable');

                //Report
                Route::any('payment/history', 'depositHistory')->name('deposit.history');

                Route::post('add-device-token', 'addDeviceToken')->name('add.device.token');
            });

            //Profile setting
            Route::controller('ProfileController')->group(function () {
                Route::get('profile-setting', 'profile')->name('profile.setting');
                Route::post('profile-setting', 'submitProfile');
                Route::get('change-password', 'changePassword')->name('change.password');
                Route::post('change-password', 'submitPassword');
            });

            Route::controller('ShippingAddressController')->group(function () {
                Route::get('shipping/address', 'index')->name('shipping.address');
                Route::post('shipping/address/store/{id?}', 'store')->name('shipping.address.store');
                Route::post('shipping/address/delete/{id}', 'delete')->name('shipping.address.delete');
            });

            // order controller
            Route::controller('OrderController')->prefix('order')->name('order.')->group(function () {
                Route::get('/', 'allOrders')->name('index');
                Route::get('pending', 'pendingOrders')->name('pending');
                Route::get('processing', 'processingOrders')->name('processing');
                Route::get('dispatched', 'dispatchedOrders')->name('dispatched');
                Route::get('completed', 'completedOrders')->name('completed');
                Route::get('canceled', 'canceledOrders')->name('canceled');
                Route::get('details/{orderNumber}', 'orderDetails')->name('details');
                Route::get('confirm/{orderNumber}', 'orderConfirm')->name('confirm');
                Route::get('print/area/{orderNumber}/{id}', 'orderPrintArea')->name('print.area');
            });

            // review controller
            Route::controller('ReviewController')->prefix('review')->name('review.')->group(function () {
                Route::get('/', 'index')->name('index');
                Route::get('create/{orderId}/{productId}/{variantId?}', 'create')->name('create');
                Route::get('edit/{id}', 'edit')->name('edit');
                Route::post('store/{id?}', 'store')->name('store');
                Route::post('delete/{id}', 'delete')->name('delete');
            });



            //Notification
            Route::controller('NotificationController')->prefix('notifications')->name('notifications.')->group(function () {
                Route::get('/', 'notifications')->name('index');
                Route::get('read/{id}', 'notificationRead')->name('read');
                Route::get('read-all', 'readAllNotification')->name('read.all');
                Route::post('delete-single/{id}', 'deleteSingleNotification')->name('delete.single');
                Route::post('delete-all', 'deleteAllNotification')->name('delete.all');
            });
        });

        // Payment
        Route::prefix('deposit')->name('deposit.')->controller('Gateway\PaymentController')->group(function () {
            Route::get('payment/{orderNumber}', 'deposit')->name('index');
            Route::post('insert', 'depositInsert')->name('insert');
            Route::get('confirm', 'depositConfirm')->name('confirm');
            Route::get('manual', 'manualDepositConfirm')->name('manual.confirm');
            Route::post('manual', 'manualDepositUpdate')->name('manual.update');
        });
    });
});
